@extends('master')
@section('content')
<section id="columns" class="container">

    <div class="breadcrumb">
        <ul>
            <li class="home"><a class="home" href="#" title="Return to Home">Home</a></li>
            <li class="crumb-1"> <a href="#" title="Women's" data-gg="">Women's</a></li>
            <li class="crumb-2"> <a href="#" title="Clothing" data-gg="">Clothing</a></li>
            <li class="crumb-3 last"> Dresses</li>
        </ul>
    </div>

    <div class="content-scene-cat">
        <h4 class="title-block">Shop</h4>

        <p>Fashion has always been so temporary and uncertain. You can’t keep up with it.  This social phenomenon is very whimsical, thus we as the consumers always try to stay in touch with all the latest fashion tendencies. Obviously there is nothing wrong about it because fashion satisfies our willingness to be attractive. And also fashion is the detector of prosperity and social rank.</p>


        <div class="products-grid">

            <div class="pagination">
                <div class="holder"></div>

                <!-- Page oriented legend -->
                <!--<div id="legend1"></div>-->

                <!-- Item oriented legend -->
                <div class="item-count">
                    <div class="showing">Showing</div>
                    <div id="legend2"></div>
                </div>
            </div>


            <!-- item container -->
            <ul id="itemContainer">
                @foreach($allitems as $item)
                <li class="products-item">
                    <div class="products-post-fashion-style parent">
                        <figure>
                            <img src="{{asset($item->image_src.$item->image_name)}}" alt="" class="child img1">
                            <img src="images/product-item/product-item-img01.jpg" alt="" class="child img2">
                        </figure>
                        <div class="caption">
                            <div class="post-fashion-style-footer">
                                <div class="tovar_item_btns">
                                    <a class="tovar_view" href="product-page_{{$item->id}}"><i class="fa fa-eye"></i></a>
                                    <a class="add_bag" href="#"><i class="fa fa-shopping-cart"></i></a>
                                    <a class="add_lovelist" href="#"><i class="fa fa-heart"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bottom-content">
                        <h5>
                            <a class="product-name" href="product-page_{{$item->id}}" title="Delphine IOU Dress">{{$item->item_name}}</a>
                        </h5>
                        <div class="content-price"> 
                            <span class="product-price-new product-price"> ${{$item->item_price}} </span> 
                            <span class="old-price product-price"> ${{$item->item_price}} </span>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>
        </div>

    </div>
</section>

<script>
    /* when document is ready */
    $(function () {
        /* initiate plugin */
        $("div.holder").jPages({
            containerID: "itemContainer",
            callback: function (pages, items) {
                $("#legend1").html("Page " + pages.current + " of " + pages.count);
                $("#legend2").html(items.range.start + " - " + items.range.end + " of " + items.count);
            }
        });
    });
</script>
@stop
