@extends('master')
@section('content')
<style type="text/css">
    .add-bag{
        cursor: pointer;
    }
</style>
<section id="columns" class="container">

    <div class="breadcrumb">
        <ul>
            <li class="home"><a class="home" href="#" title="Return to Home">Home</a></li>
            <li class="crumb-1"> <a href="#" title="Women's" data-gg="">Women's</a></li>
            <li class="crumb-2"> <a href="#" title="Clothing" data-gg="">Clothing</a></li>
            <li class="crumb-3 last"> Dresses</li>
        </ul>
    </div>

    <div class="content-scene-cat">
        <div class="row product-view">
            <div class="col-md-7 view-photo">
                <div id="surround">

                    @foreach($itemImages as $itemIage)
                    <img class="cloudzoom" alt ="Cloud Zoom small image" id ="zoom1" src="{{asset($itemIage->image_src.$itemIage->image_name)}}" data-cloudzoom='zoomSizeMode:"image", autoInside: 550 '>
                    <?php
                    $item_image_1 = asset($itemIage->image_src . $itemIage->image_name);
                    break;
                    ?>
                    @endforeach
                    <div id="slider1">

                        <div class="thumbelina-but horiz top"></div>

                        <ul>
                            @foreach($itemImages as $itemIage)
                            <li>
                                <img class='cloudzoom-gallery' width="81" height="107" src="{{asset($itemIage->image_src.$itemIage->image_name)}}"
                                     data-cloudzoom ="useZoom:'.cloudzoom', image:'{{asset($itemIage->image_src.$itemIage->image_name)}}' ">
                            </li>
                            @endforeach
                        </ul>

                        <div class="thumbelina-but horiz bottom"></div>

                    </div>

                </div>
            </div>

            <div class="col-md-5 view-description">

                <div class="view-title">{{$itemData->item_name}}</div>
                <div class="article">{{$itemData->item_category}}</div>
                <div class="brend-price">
                    <div class="pull-left brend">{{$itemData->item_name}}</div>
                    <div class="pull-right view-price">${{$itemData->item_price}}</div>
                </div>

                <div class="color-select">
                    <p>Select color</p>
                    @foreach($itemColors as $color)
                    <a class="{{ $color->itemid == $item_stock_id ? ' active' : '' }}" href="product-page_{{$color->itemid}}">
                        <img width="35" src="{{asset("../storage/app/uploads/itemcolorimages/".$color->id.".".$color->item_color_image)}}" />
                    </a>
                    @endforeach
                </div>

                <div class="size-select">
                    <div class="clearfix">
                        <p class="pull-left">Select SIZE</p>
                        <span>Size &amp; Fit</span>
                    </div>
                    @foreach($itemSizes as $size)
                    <a class="sizeS" onclick="selectItemSize('{{$size->id}}','{{$size->itm_size_value}}', this)">{{$size->itm_size_value}}</a>
                    @endforeach
                </div>

                <div class="view-btn">
                    <form id="c_item_details" action="add_to_cart" method="post">
                        <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
                        <input type="text" hidden="" name="item_stock_id" value="{{$item_stock_id}}"/>
                        <input type="text" hidden="" name="item_name" value="{{$itemData->item_name}}"/>
                        <input type="text" hidden="" name="item_category" value="{{$itemData->item_category}}"/>
                        <input type="text" hidden="" name="item_image" value="{{$item_image_1}}"/>
                        <input type="text" hidden="" name="item_price" value="{{$itemData->item_price}}"/>
                        <input type="text" hidden="" name="item_size_id" id="item_size_id" value=""/>
                        <input type="text" hidden="" name="item_size" id="item_size" value=""/>
                        <input type="text" hidden="" name="item_color" value="{{$color->id}}"/>
                        <input type="text" hidden="" name="item_color_id" value="{{$color->id}}"/>
                    </form>
                    <a class="add-bag" onclick="$('#c_item_details').submit()"><i class="fa fa-shopping-cart"></i>Add to bag</a>
                    <a class="add-lovelist" href="#"><i class="fa fa-heart"></i></a>
                </div>

                <div class="shared clearfix">
                    <p>Share item with friends</p>
                    <ul>
                        <li><a class="facebook" href="#"><i class="fa fa-facebook"></i></a></li>
                        <li><a class="twitter" href="#"><i class="fa fa-twitter"></i></a></li>
                        <li><a class="linkedin" href="#"><i class="fa fa-linkedin"></i></a></li>
                        <li><a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a></li>
                        <li><a class="tumblr" href="#"><i class="fa fa-tumblr"></i></a></li>
                    </ul>
                </div>  

                <!--Information-->
                <div id="accordion" class="accordion product-information">

                    <div class="accordion-item">
                        <div class="accordion-header">
                            Description
                            <span class="accordion-item-arrow"></span>
                        </div>
                        <div class="accordion-content">
                            <?php echo $itemData->item_description; ?>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <div class="accordion-header">
                            Delivery
                            <span class="accordion-item-arrow"></span>
                        </div>
                        <div class="accordion-content">
                            <strong>Standard delivery</strong>
                            <br>
                            World-wide shipping
                            <br>
                            Free shipping over €100
                            <br>
                            4-10 days delivery
                            <br>
                            <br>
                            <strong>Easy to return</strong>
                            <br>
                            We always offer returns and refunds on all products. You have 30 days to make up your mind after you receive the products.
                            <br>
                            <br>
                            <strong>Secure and flexible payment options</strong>
                            <br>
                            We offer both Card payment, PayPal & Bank payments. Read more about our payments
                            <a href="https://strongerlabel.com/en/faq?question=Payment%20options">here.</a>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <div class="accordion-header">
                            Details
                            <span class="accordion-item-arrow"></span>
                        </div>
                        <div class="accordion-content">
                            <table class="data-table" id="product-attribute-specs-table">
                                <colgroup><col width="25%"><col></colgroup>
                                <tbody>
                                    <tr class="first odd">
                                        <th class="">Models length</th>
                                        <td class="data last">172 cm</td>
                                    </tr>
                                    <tr class="even">
                                        <th class="">Model is wearing</th>
                                        <td class="data last">S</td>
                                    </tr>
                                    <tr class="odd">
                                        <th class="">Fit</th>
                                        <td class="data last">Normal</td>
                                    </tr>
                                    <tr class="even">
                                        <th class="">Avaliable sizes</th>
                                        <td class="data last">XS, S, M, L, XL</td>
                                    </tr>
                                    <tr class="odd">
                                        <th class="">Wash instructions</th>
                                        <td class="data last">30°C / Wash separately / Do not dry tumble</td>
                                    </tr>
                                    <tr class="even">
                                        <th class="">Color</th>
                                        <td class="data last">Peach orange</td>
                                    </tr>
                                    <tr class="last odd">
                                        <th class="">Material</th>
                                        <td class="data last">73% Polyester / 23% Elastane</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <div class="accordion-header">
                            Reviews
                            <span class="accordion-item-arrow"></span>
                        </div>
                        <div class="accordion-content">
                            Lorem ipsum dolor sit amet,
                        </div>
                    </div>

                </div>   
                <!--End Information-->

            </div>

        </div>
    </div>

</section>
<section class="module">
    <div class="products-block product-view-page-item">

        <h4 class="title-block">Deals of the day</h4>

        <div class="block_content">
            <div class="owl-carousel owl-theme">
                @foreach($allitems as $item)
                <div class="item products-item">
                    <div class="products-post-fashion-style parent">
                        <figure>
                            <img src="{{asset($item->image_src.$item->image_name)}}" alt="" class="child img1">
                            <img src="images/product-item/product-item-img010.jpg" alt="" class="child img2">
                        </figure>
                        <div class="caption">
                            <div class="post-fashion-style-footer">
                                <div class="tovar_item_btns">
                                    <a class="tovar_view" href="#"><i class="fa fa-eye"></i></a>
                                    <a class="add_bag" href="#"><i class="fa fa-shopping-cart"></i></a>
                                    <a class="add_lovelist" href="#"><i class="fa fa-heart"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bottom-content">
                        <h5>
                            <a class="product-name" href="product-page_{{$item->id}}" title="Delphine IOU Dress">{{$item->item_name}}</a>
                        </h5>
                        <div class="content-price"> 
                            <span class="product-price-new product-price"> ${{$item->item_price}} </span> 
                            <span class="old-price product-price"> ${{$item->item_price}} </span>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
<script type="text/javascript" src="js/jquery-1.11.1.min.js"></script>
<!-- Accordion -->
<script type="text/javascript" src="js/accordion.js"></script>
<script type="text/javascript">
                        var accordion;
                        jQuery(document).bind("ready", function () {
                        accordion = jQuery("#accordion").accordion();
                        });</script>
<script type="text/javascript">
    var accordion;
    jQuery(document).bind("ready", function () {
    accordion = jQuery("#accordion").accordion();
    });</script>
<!-- Image Gallery -->
<!-- Include Cloud Zoom JavaScript -->
<script type="text/javascript" src="js/cloudzoom.js"></script>
<!-- Include Thumbelina JavaScript -->
<script type="text/javascript" src="js/thumbelina.js"></script>
<script type = "text/javascript">
    CloudZoom.quickStart();
    // Initialize the slider.
    $(function () {
    $('#slider1').Thumbelina({
    $bwdBut: $('#slider1 .top'),
            $fwdBut: $('#slider1 .bottom')
    });
    });
    function selectItemSize(sizeID, sizeText, element) {
    $("#item_size_id").val(sizeID);
    $("#item_size").val(sizeText);
    $(element).addClass('active');
    }
</script>
@stop