@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">Item Details</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Add Item</h3>
        </div>
        <div class="box-body">
            <form action="save-item" method="post" id="itemForm">
                <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
                <div class="form-group col-md-6">
                    <label>Item Category</label>
                    <select class="form-control" name="sl_item_category">
                        <option disabled="">Select Category</option>
                    </select>
                </div>
                <div class="form-group col-md-6">
                    <label>Item Name</label>
                    <input type="text" class="form-control" name="tf_item_name" id="tf_item_name"/>
                </div>
                <div class="form-group col-md-6">
                    <label>Item Price</label>
                    <input type="text" class="form-control" name="tf_item_price" id="tf_item_price"/>
                </div>
                <div class="form-group col-md-6">
                    <label>Item Sizes</label>
                </div>
                <div class="form-group">
                    <label>Item Colors</label>
                </div>
                <div class="form-group">
                    <label>Item Description</label>
                    <textarea name="tf_item_description" id="editorItemDescription" title="Contents"></textarea>
                </div>
                <div class="form-group">
                    <input class="btn btn-info pull-right" type="submit" value="Add"/>
                </div>
            </form>
        </div>
    </div>
</section>
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<script type="text/javascript">
$(function () {
    CKEDITOR.replace('editorItemDescription');
});

$("#itemForm").submit(function (event) {
    event.preventDefault();
    CKEDITOR.instances['editorItemDescription'].updateElement();
    $("#itemForm").submit();
});
</script>
@stop