@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">Item Configurations</li>
        <li class="active">Item Sizes</li>
    </ol>
</section>
<section class="content">
    @if(Session::has("emsg"))
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-ban"></i> Alert!</h4>
        {{Session::get("emsg")}}
        <?php Session::forget("emsg"); ?>
    </div>
    @elseif(Session::has("smsg"))
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Alert!</h4>
        {{Session::get("smsg")}}
        <?php Session::forget("smsg"); ?>
    </div>
    @endif
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Add Item Sizes</h3>
        </div>
        <div class="box-body">
            <form action="saveitemsizes" method="post" id="form-itemsize">
            <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
                <div class="form-group">
                    <label>Item Size</label>
                    <input type="text" class="form-control" name="tf_item_size" id="tf_item_size"/>
                </div>
                <div class="form-group">
                    <label>Item Size Description</label>
                    <textarea name="tf_itemsize_description" id="editorSizeDescription" title="Contents"></textarea>
                </div>
                <div class="form-group">
                    <input class="btn btn-info pull-right" type="submit" value="Add"/>
                </div>
            </form>
        </div>
    </div>
    <div class="box box-solid box-info">
        <div class="box-header with-border">
            <h3 class="box-title">All Item Sizes</h3>
        </div>
        <div class="box-body">
            <table class="table table-bordered" id="datatable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Item Size</th>
                        <th>Description</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 0;
                    ?>
                    @foreach($itemsizes as $itemSize)
                    <?php $i++; ?>
                    <tr>
                        <td>{{$i}}</td>
                        <td>{{$itemSize->itm_size_value}}</td>
                        <td><?php echo $itemSize->item_size_description; ?></td>
                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script type="text/javascript">
$(function () {
    CKEDITOR.replace('editorSizeDescription');
});

$("#form-itemsize").submit(function (event) {
    event.preventDefault();
    CKEDITOR.instances['editorSizeDescription'].updateElement();
    $("#form-itemsize").submit();
});
</script>
@stop