@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">Item Configurations</li>
        <li class="active">Item Colors</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    @if(Session::has("emsg"))
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-ban"></i> Alert!</h4>
        {{Session::get("emsg")}}
        <?php Session::forget("emsg"); ?>
    </div>
    @elseif(Session::has("smsg"))
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Alert!</h4>
        {{Session::get("smsg")}}
        <?php Session::forget("smsg"); ?>
    </div>
    @endif
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Add Item Color</h3>
        </div>
        <!--enctype="multipart/form-data"-->
        <form action="save-item-color" method="post"  id="saveItemColor" enctype="multipart/form-data">
            <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
            <div class="box-body">
                <div class="form-group">
                    <label>Item Color</label>
                    <input type="text" class="form-control" name="tf_item_color" id="tf_item_color"/>
                </div>
                <div class="form-group">
                    <label>Item Color Description</label>
                    <textarea name="tf_color_descrition" id="editorColorDescription"  title="Contents"></textarea>
                </div>
                <div class="form-group">
                    <label>Item Color Image</label>
                    <input type="file" class="form-control" name="tf_item_colorimage" id="tf_item_colorimage"/>
                    <img id="selectedImage" src="" />
                </div>
                <div class="form-group">
                    <input class="btn btn-info pull-right" type="submit" value="Save"/>
                </div>
            </div>
        </form>
    </div>
    <div class="box box-solid box-info">
        <div class="box-header with-border">
            <h3 class="box-title">All Item Colors</h3>
        </div>
        <div class="box-body">
            <table class="table table-bordered" id="datatable" >
                <tr>
                    <th>#</th>
                    <th>Item Color</th>
                    <th>Color Image</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
                <?php
                $i = 0;
                ?>
                <tbody>
                    @foreach($itemcolors as $itemColor)
                    <?php $i++; ?>
                    <tr>
                        <td>{{$i}}</td>
                        <td>{{$itemColor->item_color_value}}</td>
                        <td>{{$itemColor->item_color_image}}</td>
                        <td><?php echo $itemColor->item_color_description; ?></td>
                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script type="text/javascript">
$(function () {
    CKEDITOR.replace('editorColorDescription');
});
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function (e) {
            $('#selectedImage').attr('src', e.target.result);
        };

        reader.readAsDataURL(input.files[0]);
    }
}
$("#saveItemColor").submit(function (event) {
    event.preventDefault();
    CKEDITOR.instances['editorColorDescription'].updateElement();
    $("#saveItemColor").submit();
});

$("#tf_item_colorimage").change(function () {
    readURL(this);
});
</script>
@stop