@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">Item Configurations</li>
        <li class="active">Item Category</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    @if(Session::has("emsg"))
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-ban"></i> Alert!</h4>
        {{Session::get("emsg")}}
        <?php Session::foget("emsg"); ?>
    </div>
    @elseif(Session::has("smsg"))
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Alert!</h4>
        {{Session::get("smsg")}}
        <?php Session::forget("smsg"); ?>
    </div>
    @endif
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Add Item Category</h3>
        </div>
        <div class="box-body">
            <form action="save-item-category" id="itemCategoryForm" method="post">
                <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
                <div class="form-group">
                    <label>Item Category</label>
                    <input type="text" class="form-control" name="tf_item_category" id="tf_item_category"/>
                </div>
                <div class="form-group">
                    <label>Item Catrgory Description</label>
                    <textarea name="tf_itemcategory_description" id="editorCategoryDescription" name="ta_category_description"title="Contents"></textarea>
                </div>
                <div class="form-group">
                    <input class="btn btn-info pull-right" type="submit" value="Add"/>
                </div>
            </form>
        </div>
    </div>
    <div class="box box-solid box-info">
        <div class="box-header with-border">
            <h3 class="box-title">All Item Categories</h3>
        </div>
        <div class="box-body">
            <table class="table table-bordered" id="datatable">
                <tr>
                    <th>#</th>
                    <th>Item Category</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
                <tbody>
                    <?php $i = 0; ?>
                    @foreach($itemcategories as $itemcategory)
                    <?php $i++; ?>
                    <tr>
                        <td>{{$i}}</td>
                        <td>{{$itemcategory->item_category}}</td>
                        <td>{{$itemcategory->item_category_description}}</td>
                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script type="text/javascript">
$(function () {
    CKEDITOR.replace('editorCategoryDescription');
});

$("#itemCategoryForm").submit(function (event) {
    event.preventDefault();
    CKEDITOR.instances['editorCategoryDescription'].updateElement();
    $("#itemCategoryForm").submit();
});
</script>
@stop