@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">Item Details</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    @if(Session::has("emsg"))
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-ban"></i> Alert!</h4>
        {{Session::get("emsg")}}
        <?php Session::forget("emsg"); ?>
    </div>
    @elseif(Session::has("smsg"))
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Alert!</h4>
        {{Session::get("smsg")}}
        <?php Session::forget("smsg"); ?>
    </div>
    @endif
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Add Item</h3>
        </div>
        <div class="box-body">
            <form action="save-item" method="post" enctype="multipart/form-data" id="itemForm">
                <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
                <div class="form-group col-md-6">
                    <label>Item Category</label>
                    <select class="form-control" name="sl_item_category">
                        <option selected="" disabled="">Select Category</option>
                        @foreach($allCategories as $category)
                        <option value="{{$category->id}}">{{$category->item_category}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-md-6">
                    <label>Item Name</label>
                    <input type="text" class="form-control" name="tf_item_name" id="tf_item_name"/>
                </div>
                <div class="form-group col-md-6">
                    <label>Item Price</label>
                    <input type="text" class="form-control" name="tf_item_price" id="tf_item_price"/>
                </div>
                <div class="form-group col-md-6">
                    <label>Item Sizes</label>
                    <div class="size-select">
                        @foreach($allSizes as $size)
                        <a class="" onclick="selectSize('{{$size->id}}','{{$size->itm_size_value}}', this)">{{$size->itm_size_value}}</a>
                        @endforeach
                        <input type="text" hidden="" name="selectedSizes" id="selectedSizes" value=""/>
                    </div>
                </div>
                <div class="form-group col-md-12">
                    <label>Item Colors</label>
                    <div class="color-select">
                        @foreach($allColors as $color)
                        <a class="color" onclick="selectColor('{{$color->id}}', this)">
                            <img width="25" src="{{asset("../storage/app/uploads/itemcolorimages/".$color->id.".".$color->item_color_image)}}" />
                        </a>
                        @endforeach
                        <input type="text" hidden="" name="selectedColors" id="selectedColors" value=""/>
                    </div>
                </div>
                <div class="form-group">
                    <label>Item Image</label>
                    <input type="file" class="form-control" name="tf_item_image" id="tf_item_image"/>
                    <img id="selectedImage" src="" />
                </div>
                <div class="form-group">
                    <label>Item Description</label>
                    <textarea name="tf_item_description" id="editorItemDescription" title="Contents"></textarea>
                </div>
                <div class="form-group">
                    <input class="btn btn-info pull-right" type="submit" value="Add"/>
                </div>
            </form>
        </div>
    </div>
</section>
<div class="modal" id="addweight-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">x</span></button>
                <h4 class="modal-title">Add Weight</h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <input type="text" class="form-control" name="sl_size_weight" id="sl_size_id" title="Size"/>
                    <label>Size</label>
                    <input type="text" class="form-control" name="sl_size_weight" id="sl_size" title="Size"/>
                </div>
                <div class="form-group">
                    <label>Weight</label>
                    <input type="text" class="form-control" name="sl_size_weight" id="sl_size_weight" title="Weight"/>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="addWeightAndSize()">Add</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script type="text/javascript">
                    $(function () {
                    CKEDITOR.replace('editorItemDescription');
                    });
                    $("#itemForm").submit(function (event) {
                    event.preventDefault();
                    CKEDITOR.instances['editorItemDescription'].updateElement();
                    $("#itemForm").submit();
                    });
                    var selectedColors = [];
                    var selectedSizes = [];
                    var selectedSizElement = null;
                    function selectColor(colorID, element) {
                    if (!$(element).hasClass("active")){
                    selectedColors.push(colorID);
                    $("#selectedColors").val(JSON.stringify(selectedColors));
                    $(element).addClass("active");
                    } else{
                    var element_string = JSON.parse($("#selectedColors").val());
                    var index = element_string.indexOf(colorID);
                    $(element).removeClass("active");
                    selectedColors.splice(index, 1);
                    $("#selectedColors").val(JSON.stringify(selectedColors));
                    }
                    }
                    function selectSize(sizeID, size, element) {
                    if (!$(element).hasClass("active")){
                    selectedSizElement = element;
                    $("#sl_size_id").val(sizeID);
                    $("#sl_size").val(size);
                    $("#addweight-modal").modal('show');
                    $("#sl_size_weight").focus();
                    } else{
                    selectedSizes.forEach(function(item, index){
                    if (item.sizeid == sizeID){
                    selectedSizes.splice(index, 1);
                    }
                    });
                    $(element).removeClass("active");
                    $("#selectedSizes").val(JSON.stringify(selectedSizes));
                    }
                    }

                    function addWeightAndSize() {
                    var size_weight = {
                    sizeid:$("#sl_size_id").val(),
                            weight:$("#sl_size_weight").val()
                    }
                    $("#sl_size_weight").val("");
                    selectedSizes.push(size_weight);
                    $("#selectedSizes").val(JSON.stringify(selectedSizes));
                    $(selectedSizElement).addClass("active");
                    $("#addweight-modal").modal('hide');
                    }

                    function readURL(input) {
                    if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                    $('#selectedImage').attr('src', e.target.result);
                    };
                    reader.readAsDataURL(input.files[0]);
                    }
                    }
                    $("#tf_item_image").change(function () {
                    readURL(this);
                    });
</script>
@stop