@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">All Items</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    <div class="box box-solid box-info">
        <div class="box-header with-border">
            <h3 class="box-title">All Items</h3>
        </div>
        <div class="box-body">
            <table class="table table-bordered" id="datatable">
                <tr>
                    <th>#</th>
                    <th>Item Name</th>
                    <th>Description</th>
                    <th>Price</th>
                    <th>Actions</th>
                </tr>
                <tbody>
                    <?php
                    $i = 0;
                    ?>
                    @foreach($itemDetails as $item)
                    <?php $i++; ?>
                    <tr>
                        <td>{{$i}}</td>
                        <td>{{$item->item_name}}</td>
                        <td><?php echo $item->item_description; ?></td>
                        <td>{{$item->item_price}}</td>
                        <td>
                            <a href="additemimages_{{$item->id}}"><button class="btn btn-primary">Add Images</button></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script type="text/javascript">
$(function () {
    CKEDITOR.replace('editorItemDescription');
});

$("#itemForm").submit(function (event) {
    event.preventDefault();
    CKEDITOR.instances['editorItemDescription'].updateElement();
    $("#itemForm").submit();
});
</script>
@stop