@extends('home')
@section('content')
<section class="content-header">
    <h1>
        Dashboard
        <small>Control panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Items</li>
        <li class="active">Add Item Images for {{$basci_details->item_name}}</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    <div class="box box-solid box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Add Item Images for {{$basci_details->item_name}}</h3>
        </div>
        <div class="box-body">
            <table class="table table-bordered" id="datatable">
                <tr>
                    <th>#</th>
                    <th>Color Value</th>
                    <th>Item Color</th>
                    <th>Actions</th>
                </tr>
                <tbody>
                    <?php
                    $i = 0;
                    ?>
                    @foreach($colors as $color)
                    <?php 
                    $i++;
                    ?>
                    <tr>
                        <td>{{$i}}</td>
                        <td>{{$color->color_value}}</td>
                        <td><img width="50" src="{{asset("../storage/app/uploads/itemcolorimages/".$color->colorid.".".$color->color_image)}}" /></td>
                        <td>
                            <button class="btn btn-primary" onclick="showUploadPopup('{{$color->item_basic_id}}','{{$color->colorid}}')">Upload Images</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>

<div class="modal" id="addimage-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">x</span></button>
                <h4 class="modal-title">Add Images</h4>
            </div>
            <div class="modal-body">
                <form action="dropzone-upload" method="post" enctype="multipart/form-data" class="dropzone" id="imageupload">
                    <input hidden="" type="text" name="item_basic_id" id="item_basic_id" value=""/>
                    <input hidden="" type="text" name="item_color_id" id="item_color_id" value=""/>
                    <input hidden="" type="text" name="_token" id="csrftoken" value="{{csrf_token()}}"/>
                    <div>
                        <h3>Upload Multiple Image By Click On Box</h3>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <!--<button type="button" class="btn btn-primary" onclick="addWeightAndSize()">Add</button>-->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script type="text/javascript">
                                $(function () {
                                CKEDITOR.replace('editorItemDescription');
                                });
                                $("#itemForm").submit(function (event) {
                                event.preventDefault();
                                CKEDITOR.instances['editorItemDescription'].updateElement();
                                $("#itemForm").submit();
                                });
                                function showUploadPopup(itembasic_id, itemcolor_id) {
                                $("#item_basic_id").val(itembasic_id);
                                $("#item_color_id").val(itemcolor_id);
                                $('#addimage-modal').modal('show');
                                }
                                $(function(){
                                Dropzone.options.imageupload = {
                                        paramName:file,
                                        maxFilesize: 10,
                                        addRemoveLinks: true,
                                        dictResponseError: 'Server not Configured',
                                        acceptedFiles: ".png,.jpg,.gif,.bmp,.jpeg",
                                        init:function(){
                                        var self = this;
                                        // config
                                        self.options.addRemoveLinks = true;
                                        self.options.dictRemoveFile = "Delete";
                                        //New file added
                                        self.on("addedfile", function (file) {
                                        console.log('new file added ', file);
                                        });
                                        // Send file starts
                                        self.on("sending", function (file) {
                                        console.log('upload started', file);
                                        $('.meter').show();
                                        });
                                        // File upload Progress
                                        self.on("totaluploadprogress", function (progress) {
                                        console.log("progress ", progress);
                                        $('.roller').width(progress + '%');
                                        });
                                        self.on("queuecomplete", function (progress) {
                                            alert("done");
                                        $('.meter').delay(999).slideUp(999);
                                        });
                                        // On removing file
                                        self.on("removedfile", function (file) {
                                        console.log(file);
                                        });
                                        }
                                };
                                });
</script>
@stop