@extends('master')
@section('content')
<section id="columns" class="container">

    <div class="breadcrumb">
        <ul>
            <li class="home"><a class="home" href="#" title="Return to Home">Home</a></li>
            <li class="crumb-1"> <a href="#" title="Women's" data-gg="">Women's</a></li>
            <li class="crumb-2"> <a href="#" title="Clothing" data-gg="">Clothing</a></li>
            <li class="crumb-3 last"> Dresses</li>
        </ul>
    </div>

    <div class="content-scene-cat">
        <div class="row checkout-wrap">

            <!--Left Box-->
            <div class="col-md-6 left-wrap">

                <div class="block-cart">
                    <h4 class="title-block"><span>1</span>Your shopping bag</h4>
                    <?php
                    $cart = Session::get('cartdata');
                    $cart_total = 0;
                    ?>
                    <div class="block-items">
                        <ol class="products-list">
                            <div class="cart-items-wrapper">
                                <div class="cart-items">
                                    @foreach($cart as $cartitem)
                                    <?php
                                    $cart_total = $cart_total + floatval($cartitem['item_price']);
                                    ?>
                                    <li class="rowItem">
                                        <div class="item-column-1">
                                            <div class="product-img-box item-image"> 
                                                <a href="#" title="Jamaica" class="product-image"> 
                                                    <img src="{{$cartitem['item_image']}}" alt="Jamaica" width="192" height="288">
                                                </a> 
                                            </div>
                                        </div>

                                        <div class="item-column-2"> 
                                            <span class="item-price"> 
                                                <span class="price"> ${{$cartitem['item_price']}} </span> 
                                            </span>
                                            <div class="product-details item-info">
                                                <h5 class="item-name-label">Product</h5>
                                                <p class="item-name"> 
                                                    <a href="#"> {{$cartitem['item_name']}} </a> 
                                                </p>
                                                <span class="product-category item-category">  {{$cartitem['item_category']}}  </span>
                                                <div class="item-action"> 
                                                    <a data-product-id="1963" data-attribute-id="1002" data-attribute-value="187" href="#">
                                                        <i class="fa fa-trash-o"></i><span class="item-action-delete-text desktop">Remove</span>
                                                    </a> 
                                                </div>
                                            </div>

                                            <div class="choices desktop">
                                                <div class="choice item-size"> <span class="choice-label">Size</span>
                                                    <div class="choice-value"> {{$cartitem['item_size']}} </div>
                                                </div>
                                                <div class="choice item-qty"> <span class="choice-label">Quantity</span>
                                                    <div class="choice-value">1</div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach
                                </div>
                            </div>
                        </ol>
                    </div>

                </div>

                <form action="" id="sky-form" class="sky-form">
                    <div class="billing-address">
                        <h4 class="title-block"><span>2</span>Address</h4>

                        <div class="address-content">

                            <div class="row">
                                <section class="col col-12">
                                    <label class="label">Email</label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                            </div>

                            <div class="row">
                                <section class="col col-6">
                                    <label class="label">First Name</label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                                <section class="col col-6">
                                    <label class="label">Last Name </label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                            </div>

                            <div class="row">
                                <section class="col col-12">
                                    <label class="label">Address</label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>

                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                            </div>

                            <div class="row">
                                <section class="col col-6">
                                    <label class="label">Zip Code</label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                                <section class="col col-6">
                                    <label class="label">City</label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                            </div>

                            <div class="row">
                                <section class="col col-12">
                                    <label class="label">Phone</label>
                                    <label class="input">
                                        <i class="icon-append fa fa-user"></i>
                                        <input type="text" name="required">
                                    </label>
                                </section>
                            </div>

                            <div class="row">
                                <section class="col col-12">
                                    <label class="label">Country</label>
                                    <label class="select">
                                        <select>
                                            <option value="Select" selected="selected"></option>
                                            <option value="Antigua">Antigua</option>
                                            <option value="Afghanistan">Afghanistan</option>
                                            <option value="Albania">Albania</option>
                                            <option value="Algarve">Algarve</option>
                                            <option value="Algeria">Algeria</option>
                                            <option value="American Samoa">American Samoa</option>
                                            <option value="Andorra">Andorra</option>
                                            <option value="Angola">Angola</option>
                                            <option value="Anguilla">Anguilla</option>
                                            <option value="Antarctica">Antarctica</option>
                                            <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                            <option value="Argentina">Argentina</option>
                                            <option value="Armenia">Armenia</option>
                                            <option value="Aruba">Aruba</option>
                                            <option value="Ascension Island">Ascension Island</option>
                                            <option value="Australia">Australia</option>
                                            <option value="Austria">Austria</option>
                                            <option value="Azerbaijan">Azerbaijan</option>
                                            <option value="Bahrain">Bahrain</option>
                                            <option value="Balearic Islands (Spain)">Balearic Islands (Spain)</option>
                                            <option value="Bangladesh">Bangladesh</option>
                                            <option value="Barbados">Barbados</option>
                                            <option value="Belarus">Belarus</option>
                                            <option value="Belgium">Belgium</option>
                                            <option value="Belize">Belize</option>
                                            <option value="Benin">Benin</option>
                                            <option value="Bermuda">Bermuda</option>
                                            <option value="Bhutan">Bhutan</option>
                                            <option value="Bolivia">Bolivia</option>
                                            <option value="Bosnia and Herzegowina">Bosnia and Herzegowina</option>
                                            <option value="Botswana">Botswana</option>
                                            <option value="Bouvet Island">Bouvet Island</option>
                                            <option value="Brazil">Brazil</option>
                                            <option value="British Indian Ocean Terri">British Indian Ocean Terri</option>
                                            <option value="British West Indies">British West Indies</option>
                                            <option value="Brunei">Brunei</option>
                                            <option value="Bulgaria">Bulgaria</option>
                                            <option value="Burkina Faso">Burkina Faso</option>
                                            <option value="Burma">Burma</option>
                                            <option value="Burundi">Burundi</option>
                                            <option value="Cambodia">Cambodia</option>
                                            <option value="Cameroon">Cameroon</option>
                                            <option value="Canada">Canada</option>
                                            <option value="Canary Islands">Canary Islands</option>
                                            <option value="Cape Verde">Cape Verde</option>
                                            <option value="Central African Republic">Central African Republic</option>
                                            <option value="Chad">Chad</option>
                                            <option value="Chile">Chile</option>
                                            <option value="China">China</option>
                                            <option value="Christmas Island">Christmas Island</option>
                                            <option value="Cocos">Cocos</option>
                                            <option value="Colombia">Colombia</option>
                                            <option value="Comoros">Comoros</option>
                                            <option value="Congo">Congo</option>
                                            <option value="Cook Islands">Cook Islands</option>
                                            <option value="Costa Rica">Costa Rica</option>
                                            <option value="Cote D'Ivoire">Cote D'Ivoire</option>
                                            <option value="Croatia">Croatia</option>
                                            <option value="Cuba">Cuba</option>
                                            <option value="Curacao">Curacao</option>
                                            <option value="Cyprus">Cyprus</option>
                                            <option value="Czech Republic">Czech Republic</option>
                                            <option value="Denmark">Denmark</option>
                                            <option value="Djibouti">Djibouti</option>
                                            <option value="Dominica">Dominica</option>
                                            <option value="Dominican Republic">Dominican Republic</option>
                                            <option value="East Timor">East Timor</option>
                                            <option value="Ecuador">Ecuador</option>
                                            <option value="Egypt">Egypt</option>
                                            <option value="El Salvador">El Salvador</option>
                                            <option value="Equatorial Guinea">Equatorial Guinea</option>
                                            <option value="Eritrea">Eritrea</option>
                                            <option value="Estonia">Estonia</option>
                                            <option value="Ethiopia">Ethiopia</option>
                                            <option value="Falklands Islands">Falklands Islands</option>
                                            <option value="Faroe Islands">Faroe Islands</option>
                                            <option value="Fiji">Fiji</option>
                                            <option value="Finland">Finland</option>
                                            <option value="France">France</option>
                                            <option value="French Guiana">French Guiana</option>
                                            <option value="French Polynesia">French Polynesia</option>
                                            <option value="French Southern Territorie">French Southern Territorie</option>
                                            <option value="Gabon">Gabon</option>
                                            <option value="Gambia">Gambia</option>
                                            <option value="Gaza">Gaza</option>
                                            <option value="Georgia">Georgia</option>
                                            <option value="Germany">Germany</option>
                                            <option value="Ghana">Ghana</option>
                                            <option value="Gibraltar">Gibraltar</option>
                                            <option value="Greece">Greece</option>
                                            <option value="Greenland">Greenland</option>
                                            <option value="Grenada">Grenada</option>
                                            <option value="Guadeloupe">Guadeloupe</option>
                                            <option value="Guam">Guam</option>
                                            <option value="Guatemala">Guatemala</option>
                                            <option value="Guinea">Guinea</option>
                                            <option value="Guinea-Bissau">Guinea-Bissau</option>
                                            <option value="Guyana">Guyana</option>
                                            <option value="Haiti">Haiti</option>
                                            <option value="Heard and Mc Donald Island">Heard and Mc Donald Island</option>
                                            <option value="Held Territories">Held Territories</option>
                                            <option value="Honduras">Honduras</option>
                                            <option value="Hong Kong">Hong Kong</option>
                                            <option value="Hungary">Hungary</option>
                                            <option value="Ibiza">Ibiza</option>
                                            <option value="Iceland">Iceland</option>
                                            <option value="India">India</option>
                                            <option value="Indonesia">Indonesia</option>
                                            <option value="Iran">Iran</option>
                                            <option value="Iraq">Iraq</option>
                                            <option value="Ireland">Ireland</option>
                                            <option value="Isle of Man">Isle of Man</option>
                                            <option value="Israel">Israel</option>
                                            <option value="Italy">Italy</option>
                                            <option value="Jamaica">Jamaica</option>
                                            <option value="Japan">Japan</option>
                                            <option value="Jersey">Jersey</option>
                                            <option value="Jordan">Jordan</option>
                                            <option value="Kazakhstan">Kazakhstan</option>
                                            <option value="Kenya">Kenya</option>
                                            <option value="Kiribati">Kiribati</option>
                                            <option value="Kuwait">Kuwait</option>
                                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                                            <option value="Laos">Laos</option>
                                            <option value="Latvia">Latvia</option>
                                            <option value="Lebanon">Lebanon</option>
                                            <option value="Lesotho">Lesotho</option>
                                            <option value="Liberia">Liberia</option>
                                            <option value="Libya">Libya</option>
                                            <option value="Liechtenstein">Liechtenstein</option>
                                            <option value="Lithuania">Lithuania</option>
                                            <option value="Luxembourg">Luxembourg</option>
                                            <option value="Macao">Macao</option>
                                            <option value="Macedonia">Macedonia</option>
                                            <option value="Madagascar">Madagascar</option>
                                            <option value="Madeira">Madeira</option>
                                            <option value="Majorca">Majorca</option>
                                            <option value="Malawi">Malawi</option>
                                            <option value="Malaysia">Malaysia</option>
                                            <option value="Maldives">Maldives</option>
                                            <option value="Mali">Mali</option>
                                            <option value="Malta">Malta</option>
                                            <option value="Marshall Islands">Marshall Islands</option>
                                            <option value="Martinique">Martinique</option>
                                            <option value="Mauritania">Mauritania</option>
                                            <option value="Mauritius">Mauritius</option>
                                            <option value="Mayotte">Mayotte</option>
                                            <option value="Menorca">Menorca</option>
                                            <option value="Mexico">Mexico</option>
                                            <option value="Micronesia">Micronesia</option>
                                            <option value="Moldova">Moldova</option>
                                            <option value="Monaco">Monaco</option>
                                            <option value="Mongolia">Mongolia</option>
                                            <option value="Montserrat">Montserrat</option>
                                            <option value="Morocco">Morocco</option>
                                            <option value="Mozambique">Mozambique</option>
                                            <option value="Myanmar">Myanmar</option>
                                            <option value="Namibia">Namibia</option>
                                            <option value="Nauru">Nauru</option>
                                            <option value="Nepal">Nepal</option>
                                            <option value="Netherlands">Netherlands</option>
                                            <option value="Netherlands Antilles">Netherlands Antilles</option>
                                            <option value="New Caledonia">New Caledonia</option>
                                            <option value="New Zealand">New Zealand</option>
                                            <option value="Nicaragua">Nicaragua</option>
                                            <option value="Niger">Niger</option>
                                            <option value="Nigeria">Nigeria</option>
                                            <option value="Niue">Niue</option>
                                            <option value="Norfolk Island">Norfolk Island</option>
                                            <option value="North Cyprus">North Cyprus</option>
                                            <option value="North Korea">North Korea</option>
                                            <option value="Northern Ireland">Northern Ireland</option>
                                            <option value="Northern Mariana Islands">Northern Mariana Islands</option>
                                            <option value="Norway">Norway</option>
                                            <option value="Oman">Oman</option>
                                            <option value="Pakistan">Pakistan</option>
                                            <option value="Palau">Palau</option>
                                            <option value="Panama">Panama</option>
                                            <option value="Papua New Guinea">Papua New Guinea</option>
                                            <option value="Paraguay">Paraguay</option>
                                            <option value="Peru">Peru</option>
                                            <option value="Philippines">Philippines</option>
                                            <option value="Pitcairn">Pitcairn</option>
                                            <option value="Poland">Poland</option>
                                            <option value="Portugal">Portugal</option>
                                            <option value="Puerto Rico">Puerto Rico</option>
                                            <option value="Qatar">Qatar</option>
                                            <option value="Republic of Serbia">Republic of Serbia</option>
                                            <option value="Reunion">Reunion</option>
                                            <option value="Romania">Romania</option>
                                            <option value="Russia">Russia</option>
                                            <option value="Rwanda">Rwanda</option>
                                            <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                            <option value="Saint Lucia">Saint Lucia</option>
                                            <option value="Samoa">Samoa</option>
                                            <option value="San Marino">San Marino</option>
                                            <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                                            <option value="Saudi Arabia">Saudi Arabia</option>
                                            <option value="Scotland">Scotland</option>
                                            <option value="Senegal">Senegal</option>
                                            <option value="Seychelles">Seychelles</option>
                                            <option value="Sierra Leone">Sierra Leone</option>
                                            <option value="Singapore">Singapore</option>
                                            <option value="Slovakia">Slovakia</option>
                                            <option value="Slovenia">Slovenia</option>
                                            <option value="Solomon Islands">Solomon Islands</option>
                                            <option value="Somalia">Somalia</option>
                                            <option value="South Africa">South Africa</option>
                                            <option value="South Georgia">South Georgia</option>
                                            <option value="South Korea">South Korea</option>
                                            <option value="South Sanfransisco">South Sanfransisco</option>
                                            <option value="Spain">Spain</option>
                                            <option value="Spanish Mainland">Spanish Mainland</option>
                                            <option value="Sri Lanka">Sri Lanka</option>
                                            <option value="St. Helena">St. Helena</option>
                                            <option value="St. Pierre">St. Pierre</option>
                                            <option value="St. Vincent &amp; The Grendadines">St. Vincent &amp; The Grendadines</option>
                                            <option value="Sudan">Sudan</option>
                                            <option value="Suriname">Suriname</option>
                                            <option value="Svalbard And Jan Mayen Islands">Svalbard And Jan Mayen Islands</option>
                                            <option value="Swaziland">Swaziland</option>
                                            <option value="Sweden">Sweden</option>
                                            <option value="Switzerland">Switzerland</option>
                                            <option value="Syria">Syria</option>
                                            <option value="Taiwan">Taiwan</option>
                                            <option value="Tajikistan">Tajikistan</option>
                                            <option value="Tanzania">Tanzania</option>
                                            <option value="Thailand">Thailand</option>
                                            <option value="The Bahamas">The Bahamas</option>
                                            <option value="The Cayman Islands">The Cayman Islands</option>
                                            <option value="Togo">Togo</option>
                                            <option value="Tokelau">Tokelau</option>
                                            <option value="Tonga">Tonga</option>
                                            <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                            <option value="Tunisia">Tunisia</option>
                                            <option value="Turkey">Turkey</option>
                                            <option value="Turkmenistan">Turkmenistan</option>
                                            <option value="Turks And Caicos Islands">Turks And Caicos Islands</option>
                                            <option value="Tuvalu">Tuvalu</option>
                                            <option value="U.S. Minor Outlying Islands">U.S. Minor Outlying Islands</option>
                                            <option value="Uganda">Uganda</option>
                                            <option value="Ukraine">Ukraine</option>
                                            <option value="United Arab Emirates">United Arab Emirates</option>
                                            <option value="United Kingdom">United Kingdom</option>
                                            <option value="United States">United States</option>
                                            <option value="United_Kingdom">United_Kingdom</option>
                                            <option value="Uruguay">Uruguay</option>
                                            <option value="Uzbekistan">Uzbekistan</option>
                                            <option value="Vanuatu">Vanuatu</option>
                                            <option value="Vatican City State">Vatican City State</option>
                                            <option value="Venezuela">Venezuela</option>
                                            <option value="Vietnam">Vietnam</option>
                                            <option value="Virgin Islands">Virgin Islands</option>
                                            <option value="Virgin Islands - U.S ?">Virgin Islands - U.S ?</option>
                                            <option value="Wales">Wales</option>
                                            <option value="Wallis And Futuna Islands">Wallis And Futuna Islands</option>
                                            <option value="Western Sahara">Western Sahara</option>
                                            <option value="Yemen">Yemen</option>
                                            <option value="Yugoslavia">Yugoslavia</option>
                                            <option value="Zaire">Zaire</option>
                                            <option value="Zambia">Zambia</option>
                                            <option value="Zimbabwe">Zimbabwe</option>
                                        </select>
                                        <i></i>
                                    </label>
                                </section>
                            </div>

                        </div>

                        <div class="shipping-method">
                            <h4 class="title-block"><span>3</span>Shipping method</h4>

                            <div class="checkout-shipping-method">

                                <ul class="sp-methods">
                                    <li>
                                        <input type="radio" name="radio" id="radio" class="radio" checked/>
                                        <label for="radio">International Parcel Delivery <span class="price">€0</span></label>
                                        <div class="methods-img">
                                            <p class="delivery-estimate">Delivery time 4-8 days</p>
                                            <p class="delivery-guarantee">Delivery guarantee</p>
                                        </div>
                                    </li>
                                </ul>

                            </div>
                        </div>

                        <div class="shipping-method">
                            <h4 class="title-block"><span>4</span>Payment</h4>

                            <div class="checkout-shipping-method">

                                <ul class="sp-methods">
                                    <li>
                                        <input type="radio" name="radio" id="radio1" class="radio" checked/>
                                        <label for="radio1">Card payment</label>
                                        <div class="methods-img">
                                            <img src="images/acc.png">
                                        </div>
                                    </li>

                                    <li>
                                        <input type="radio" name="radio" id="radio2" class="radio" checked/>
                                        <label for="radio2">PayPal</label>
                                        <div class="methods-img">
                                            <img src="images/paypal.png">
                                        </div>
                                    </li>

                                    <li>
                                        <input type="radio" name="radio" id="radio3" class="radio" checked/>
                                        <label for="radio3">Sofortueberweisung</label>
                                        <div class="methods-img">
                                            <img src="images/sofortlogo.png">
                                        </div>
                                    </li>
                                </ul>

                            </div>
                        </div>

                        <footer>
                            <button type="submit" class="button">Complete your payment</button>
                        </footer>

                </form>

            </div>

        </div>
        <!--End Left Box-->

        <!--Right Box-->
        <div class="col-md-6 right-wrap">

            <div class="totals-wrapper">
                <h3>Overview</h3>
                <div class="block-totals">
                    <table class="totals">
                        <colgroup>
                            <col>
                            <col width="1">
                        </colgroup>
                        <tfoot>
                            <tr>
                                <td style="" class="a-right" colspan="1"><strong>Grand Total:</strong></td>
                                <td style="" class="a-right"><strong><span class="price">${{$cart_total}}</span></strong></td>
                            </tr>
                        </tfoot>
                        <tbody>
                            <tr>
                                <td style="" class="a-right" colspan="1"> Subtotal: </td>
                                <td style="" class="a-right"><span class="price">${{$cart_total}}</span></td>
                            </tr>
                            <tr>
                                <td style="" class="a-right" colspan="1"> Shipping Amount: </td>
                                <td style="" class="a-right"><span class="price">$0</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>


            <div class="checkout-info-wrapper">

                <!-- Truck -->
                <div class="checkout-info-item">
                    <div class="checkout-info-icon">
                        <i class="fa fa-truck"></i>
                    </div>

                    <div class="checkout-info">
                        <h5 class="checkout-info-heading">Get free shipping!</h5>
                        <p class="checkout-info-text">Order over €100</p>
                    </div>
                </div>

                <!-- Calendar -->
                <div class="checkout-info-item">
                    <div class="checkout-info-icon">
                        <i class="fa fa-calendar-o"></i>
                    </div>

                    <div class="checkout-info">
                        <h5 class="checkout-info-heading">Fast shipping</h5>
                        <p class="checkout-info-text">We always ship your order within 24 hours</p>
                    </div>
                </div>

                <!-- Return -->
                <div class="checkout-info-item">
                    <div class="checkout-info-icon">
                        <i class="fa fa-circle-o-notch"></i>
                    </div>

                    <div class="checkout-info">
                        <h5 class="checkout-info-heading">30 days right of return</h5>
                        <p class="checkout-info-text">You can always return or change your items</p>
                    </div>
                </div>

            </div>


        </div>
        <!--End Right Box-->

    </div>
</div>
</section>
<script type="text/javascript">
    $(function ()
    {
        // Validation
        $("#sky-form").validate(
                {
                    // Rules for form validation
                    rules:
                            {
                                required:
                                        {
                                            required: true
                                        },
                                email:
                                        {
                                            required: true,
                                            email: true
                                        },
                                url:
                                        {
                                            required: true,
                                            url: true
                                        },
                                date:
                                        {
                                            required: true,
                                            date: true
                                        },
                                min:
                                        {
                                            required: true,
                                            minlength: 5
                                        },
                                max:
                                        {
                                            required: true,
                                            maxlength: 5
                                        },
                                range:
                                        {
                                            required: true,
                                            rangelength: [5, 10]
                                        },
                                digits:
                                        {
                                            required: true,
                                            digits: true
                                        },
                                number:
                                        {
                                            required: true,
                                            number: true
                                        },
                                minVal:
                                        {
                                            required: true,
                                            min: 5
                                        },
                                maxVal:
                                        {
                                            required: true,
                                            max: 100
                                        },
                                rangeVal:
                                        {
                                            required: true,
                                            range: [5, 100]
                                        }
                            },

                    // Messages for form validation
                    messages:
                            {
                                required:
                                        {
                                            required: 'Please enter something'
                                        },
                                email:
                                        {
                                            required: 'Please enter your email address'
                                        },
                                url:
                                        {
                                            required: 'Please enter your URL'
                                        },
                                date:
                                        {
                                            required: 'Please enter some date'
                                        },
                                min:
                                        {
                                            required: 'Please enter some text'
                                        },
                                max:
                                        {
                                            required: 'Please enter some text'
                                        },
                                range:
                                        {
                                            required: 'Please enter some text'
                                        },
                                digits:
                                        {
                                            required: 'Please enter some digits'
                                        },
                                number:
                                        {
                                            required: 'Please enter some number'
                                        },
                                minVal:
                                        {
                                            required: 'Please enter some value'
                                        },
                                maxVal:
                                        {
                                            required: 'Please enter some value'
                                        },
                                rangeVal:
                                        {
                                            required: 'Please enter some value'
                                        }
                            },

                    // Do not change code below
                    errorPlacement: function (error, element)
                    {
                        error.insertAfter(element.parent());
                    }
                });
    });
</script>
@stop
