<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace App\Http\Controllers;

use DB;
use App\ItemImage;

/**
 * Description of ProductController
 *
 * @author Isuru Bhagya
 */
class ProductController extends Controller {

    public function loadAllProduct() {
        $itemdetails = DB::table('tbl_item_stock')
                ->select('tbl_item_basic_details.item_name', 'tbl_item_stock.item_price', 'tbl_item_images.image_src', 'tbl_item_images.image_name', 'tbl_item_stock.id')
                ->join('tbl_item_basic_details', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_basic_details.id')
                ->join('tbl_item_images', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_images.tbl_item_basic_details_id')
                ->where('tbl_item_images.image_type', '1')
                ->groupBy('tbl_item_stock.tbl_item_basic_details_id')
                ->get();
        return view("shop")
                        ->with('allitems', $itemdetails);
    }

    public function showSingleProductDetails($id) {
        $slItemDetails = DB::table('tbl_item_stock')
                ->select('tbl_item_basic_details.id', 'tbl_item_basic_details.item_name', 'tbl_item_stock.item_price', 'tbl_item_basic_details.item_description', 'tbl_item_category.item_category', 'tbl_item_colors.id as colorid')
                ->join('tbl_item_basic_details', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_basic_details.id')
                ->join('tbl_item_category', 'tbl_item_stock.tbl_item_category_id', '=', 'tbl_item_category.id')
                ->join('tbl_item_colors', 'tbl_item_stock.tbl_item_colors_id', '=', 'tbl_item_colors.id')
                ->where('tbl_item_stock.id', $id)
                ->first();
//        $sl_item_mainiamge = ItemImage::where()
//                ->where()
//                ->first()
        $sl_itemcolors = DB::table('tbl_item_colors')
                ->select('tbl_item_colors.id', 'tbl_item_colors.item_color_image', 'tbl_item_colors.item_color_value','tbl_item_stock.id as itemid')
                ->join('tbl_item_stock', 'tbl_item_colors.id', '=', 'tbl_item_stock.tbl_item_colors_id')
                ->join('tbl_item_basic_details', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_basic_details.id')
                ->where('tbl_item_basic_details.id', $slItemDetails->id)
                ->groupBy('tbl_item_colors.id')
                ->get();
        $sl_itemsizes = DB::table('tbl_item_sizes')
                ->select('tbl_item_sizes.id', 'tbl_item_sizes.itm_size_value')
                ->join('tbl_item_stock', 'tbl_item_stock.tbl_item_sizes_id', '=', 'tbl_item_sizes.id')
                ->join('tbl_item_basic_details', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_basic_details.id')
                ->where('tbl_item_basic_details.id', $slItemDetails->id)
                ->groupBy('tbl_item_sizes.id')
                ->get();
        $itemdetails = DB::table('tbl_item_stock')
                ->select('tbl_item_basic_details.item_name', 'tbl_item_stock.item_price', 'tbl_item_images.image_src', 'tbl_item_images.image_name', 'tbl_item_stock.id')
                ->join('tbl_item_basic_details', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_basic_details.id')
                ->join('tbl_item_images', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_images.tbl_item_basic_details_id')
                ->where('tbl_item_images.image_type', '1')
                ->groupBy('tbl_item_stock.tbl_item_basic_details_id')
                ->get();
        $itemImages = DB::table('tbl_item_images')
                ->select('tbl_item_images.id', 'tbl_item_images.image_src', 'tbl_item_images.image_name')
                ->where('tbl_item_images.tbl_item_basic_details_id', $slItemDetails->id)
                ->where('tbl_item_images.tbl_item_colors_id', $slItemDetails->colorid)
                ->where('tbl_item_images.image_type', 2)
                ->get();
        return view("product-page")
                        ->with('itemData', $slItemDetails)
                        ->with('itemColors', $sl_itemcolors)
                        ->with('itemSizes', $sl_itemsizes)
                        ->with('allitems', $itemdetails)
                        ->with('itemImages', $itemImages)
                        ->with('item_stock_id',$id);
    }

}
