<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Item;
use App\ItemSize;
use App\ItemColor;
use App\ItemStock;
use App\ItemImage;
use App\ItemCategory;
use Illuminate\Support\Facades\Input;
use DB;
use Illuminate\Support\Facades\Session;

class ItemController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index() {
        $itemDetails = Item::all();
        return view("dressitems/all-items")
                        ->with('itemDetails', $itemDetails);
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create() {
        $allSizes = ItemSize::all();
        $allColors = ItemColor::all();
        $allCategories = ItemCategory::all();
        return view("dressitems/dressItem")
                        ->with('allSizes', $allSizes)
                        ->with('allColors', $allColors)
                        ->with('allCategories', $allCategories);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store(Request $request) {
        $itemName = $request->get("tf_item_name");
        $itemPrice = $request->get("tf_item_price");
        $itemDescription = $request->get("tf_item_description");
        $itemCategory = $request->get("sl_item_category");
        $itemSizes = json_decode($request->get("selectedSizes"));
        $itemColors = json_decode($request->get("selectedColors"));
        $item = new Item();
        $item->item_name = $itemName;
        $item->item_price = $itemPrice;
        $item->item_description = $itemDescription;
        $item->save();
        
        $image = $request->file('tf_item_image');
        $imageName = $item->id . "." . $image->getClientOriginalExtension();
        $image->move(storage_path('app/uploads/itemmainimages/'), $imageName);
        $itemImageM = new ItemImage();
        $itemImageM->tbl_item_basic_details_id = $item->id;
        $itemImageM->tbl_item_colors_id = '';
        $itemImageM->image_type = 1;
        $itemImageM->image_src = '../storage/app/uploads/itemmainimages/';
        $itemImageM->image_name = $imageName;
        $itemImageM->save();
        
        foreach ($itemSizes as $itemsize) {
            for ($i = 0; $i < sizeof($itemColors); $i++) {
                $itemstockdata = array(
                    'tbl_item_basic_details_id' => $item->id,
                    'tbl_item_category_id' => $itemCategory,
                    'tbl_item_sizes_id' => $itemsize->sizeid,
                    'tbl_item_colors_id' => $itemColors[$i],
                    'item_qty' => 0,
                    'item_weight' => $itemsize->weight,
                    'item_price' => $itemPrice
                );
                $itemstockcontroller = new ItemStockController();
                $itemstockcontroller->create($itemstockdata);
            }
        }
        Session::put("smsg", "Successfully Saved");
        return redirect('additemimages_' . $item->id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id) {
        
    }

    public function addItemImagesToColors($id) {
        $itembasic = DB::table('tbl_item_stock')
                ->select('tbl_item_basic_details.id', 'item_name')
                ->join('tbl_item_basic_details', 'tbl_item_stock.tbl_item_basic_details_id', '=', 'tbl_item_basic_details.id')
                ->where('tbl_item_stock.tbl_item_basic_details_id', $id)
                ->first();
        $itemColorDetails = DB::table('tbl_item_stock')
                ->select('tbl_item_colors.id as colorid', 'tbl_item_colors.item_color_value as color_value', 'tbl_item_colors.item_color_image as color_image', 'tbl_item_stock.tbl_item_basic_details_id as item_basic_id')
                ->join('tbl_item_colors', 'tbl_item_stock.tbl_item_colors_id', '=', 'tbl_item_colors.id')
                ->where('tbl_item_stock.tbl_item_basic_details_id', $id)
                ->groupBy('tbl_item_stock.tbl_item_colors_id')
                ->get();
        return view('dressitems/add-item-color-images')
                        ->with('colors', $itemColorDetails)
                        ->with('basci_details', $itembasic);
    }

    public function uploadImages(Request $request) {
        $item_basic_detail_id = $request->get('item_basic_id');
        $item_color_id = $request->get('item_color_id');
        $itemimage = DB::table('tbl_item_images')
                ->where('tbl_item_basic_details_id', $item_basic_detail_id)
                ->where('tbl_item_colors_id', $item_color_id)
                ->count();
        $count = intval($itemimage) + 1;
        $image = $request->file('file');
        $imageName = $item_basic_detail_id . "_" . $item_color_id . "_" . $count . "." . $image->getClientOriginalExtension();
        $image->move(storage_path('app/uploads/itemimages/'), $imageName);
        $itemImageM = new ItemImage();
        $itemImageM->tbl_item_basic_details_id = $item_basic_detail_id;
        $itemImageM->tbl_item_colors_id = $item_color_id;
        $itemImageM->image_type = 2;
        $itemImageM->image_src = '../storage/app/uploads/itemimages/';
        $itemImageM->image_name = $imageName;
        $itemImageM->save();
        return json_encode("Success");
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id) {
        //
    }

}
