<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\ItemColor;
use Illuminate\Http\Request;
use Storage;
use Illuminate\Support\Facades\Session;

class ItemColorController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index() {
        $itemcolors = ItemColor::all();
        return view("dressitems/itemconfigs/itemColors")
                        ->with('itemcolors', $itemcolors);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create() {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store(Request $request) {
        $itemColor = new ItemColor();
        $itemColor->item_color_value = $request->get("tf_item_color");
        $itemColor->item_color_image = $request->file('tf_item_colorimage')->getClientOriginalExtension();
        $itemColor->item_color_description = $request->get("tf_color_descrition");
        $itemColor->save();

        $imageName = $itemColor->id . '.' .
                $request->file('tf_item_colorimage')->getClientOriginalExtension();

        $request->file('tf_item_colorimage')->move(
                storage_path('app/uploads/itemcolorimages/'), $imageName
        );
        Session::put("smsg","Successfully Saved");
        return redirect()->back();
//        return \Redirect::route('admin.products.edit', array($product->id))->with('message', 'Product added!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id) {
        //
    }

}
